/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.ftp;

import com.quantumdata.ftp.Ftp;
import com.quantumdata.ftp.FtpConnect;
import com.quantumdata.ftp.FtpDataSocket;
import com.quantumdata.ftp.FtpFile;
import com.quantumdata.std.IQDConsole;
import java.io.IOException;
import java.io.OutputStream;

public final class FtpOutputStream
extends OutputStream {
    private Ftp m_client;
    private FtpDataSocket m_data;
    private OutputStream m_stream;

    public FtpOutputStream(FtpFile ftpFile) throws IOException {
        this(ftpFile, false);
    }

    public FtpOutputStream(FtpFile ftpFile, boolean bl) throws IOException {
        this.m_client = null;
        this.m_data = new FtpDataSocket(ftpFile.getClient());
        this.m_stream = bl ? this.m_data.getOutputStream("APPE " + ftpFile, ftpFile.getDataType()) : this.m_data.getOutputStream("STOR " + ftpFile, ftpFile.getDataType());
    }

    public FtpOutputStream(FtpFile ftpFile, FtpConnect ftpConnect, IQDConsole iQDConsole) throws IOException {
        this(ftpFile, ftpConnect, iQDConsole, false);
    }

    public FtpOutputStream(FtpFile ftpFile, FtpConnect ftpConnect, IQDConsole iQDConsole, boolean bl) throws IOException {
        this.m_client = new Ftp();
        if (this.m_client.connect(ftpConnect)) {
            if (iQDConsole != null) {
                this.m_client.getContext().setConsole(iQDConsole);
            }
            ftpFile = new FtpFile(ftpFile.toString(), this.m_client);
            this.m_data = new FtpDataSocket(ftpFile.getClient());
            this.m_stream = bl ? this.m_data.getOutputStream("APPE " + ftpFile, ftpFile.getDataType()) : this.m_data.getOutputStream("STOR " + ftpFile, ftpFile.getDataType());
        } else {
            throw new IOException("Connect failed.");
        }
    }

    public void close() throws IOException {
        IOException iOException = null;
        while (this.m_stream != null || this.m_data != null || this.m_client != null) {
            try {
                if (this.m_stream != null) {
                    OutputStream outputStream = this.m_stream;
                    this.m_stream = null;
                    outputStream.close();
                }
                if (this.m_data != null) {
                    FtpDataSocket ftpDataSocket = this.m_data;
                    this.m_data = null;
                    ftpDataSocket.close();
                }
                if (this.m_client == null) continue;
                Ftp ftp = this.m_client;
                this.m_client = null;
                ftp.disconnect();
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    public void write(int n) throws IOException {
        this.m_stream.write(n);
    }

    public void write(byte[] byArray) throws IOException {
        this.m_stream.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.m_stream.write(byArray, n, n2);
    }

    public void flush() throws IOException {
        this.m_stream.flush();
    }
}

